//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgArgos.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "EMF/ModFunctionsFiles/Functions.h"
#include "EMF/TreeControl/TreeFunctions.h" //==> dlarge TreeControl
#include "EMF/ModFunctionsFiles/Defaults.h"
#include "KnownFileList.h"
#include "Opcodes.h"
#include "Argos.h"
#include "emuledlg.h"
#include "transferwnd.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

class CArgosPunishment : public CTreeOptionsCombo
{
public:
	CArgosPunishment();
	virtual ~CArgosPunishment();

protected:
	//{{AFX_VIRTUAL(CArgosPunishment)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CArgosPunishment)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CArgosPunishment)
};


IMPLEMENT_DYNCREATE(CArgosPunishment, CTreeOptionsCombo)

CArgosPunishment::CArgosPunishment()
{
}

CArgosPunishment::~CArgosPunishment()
{
}

BEGIN_MESSAGE_MAP(CArgosPunishment, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CArgosPunishment)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

#define APL_ALL_AP    0
#define APL_MAX_01_AP 1
#define APL_MAX_02_AP 2
#define APL_MAX_03_AP 3
#define APL_MAX_04_AP 4
#define APL_MAX_05_AP 5
#define APL_MAX_06_AP 6
#define APL_MAX_07_AP 7
#define APL_MAX_08_AP 8
#define APL_MAX_09_AP 9
#define APL_NO_AP_UL  10
#define APL_BAN_ONLY  11
#define APL_NO_BAN	  100

int CArgosPunishment::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	int Limit = 0;
	Limit = (int)m_pTreeCtrl->GetOpaque(m_hTreeCtrlItem,TRUE);

	//Add strings to the combo
	if(Limit < APL_NO_BAN)
		AddString(GetResString(IDS_ARGOS_IP_BAN));
	else
		Limit -= APL_NO_BAN;
	if(!Limit)
		AddString(GetResString(IDS_ARGOS_UL_BAN));
	for(int i = (Limit ? Limit : 1); i<10; i++)
		AddString(StrLine(GetResString(IDS_ARGOS_SCORE),i));
	if(Limit != 11)
		AddString(GetResString(IDS_ARGOS_NO_BAN));
	
	return 0;
}

#define HANDLING_ICO_INDEX 17
void SetTreeAP(CTreeOptionsCtrl &hCtrl,HTREEITEM &hItem, LPCTSTR Label,HTREEITEM Parent, LPCTSTR Info, int pLimit = 0){
	hItem = hCtrl.InsertItem(Label, HANDLING_ICO_INDEX, HANDLING_ICO_INDEX, Parent);
	hCtrl.AddComboBox(hItem,RUNTIME_CLASS(CArgosPunishment),0,(DWORD)pLimit);
	//hCtrl.SetItemSize(hItem,10);
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeAP(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/,HTREEITEM hItem, int& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_ARGOS_IP_BAN))
			nValue = 100;
		else if(sText == GetResString(IDS_ARGOS_NO_BAN))
			nValue = 0;
		else if(sText == GetResString(IDS_ARGOS_UL_BAN))
			nValue = 10;
		else 
			nValue = 10 - _tstoi(sText.Right(1));
	}else{
		switch(nValue){
		case 0: sText = GetResString(IDS_ARGOS_NO_BAN); break;
		case 100: sText = GetResString(IDS_ARGOS_IP_BAN); break;
		case 10: sText = GetResString(IDS_ARGOS_UL_BAN); break;
		default: sText = StrLine(GetResString(IDS_ARGOS_SCORE), 10 - nValue);
		}
		hCtrl->SetComboText(hItem, sText);
	}
}

//////////////////////////////////////////////////////////////////////////

class CArgosCompensation : public CTreeOptionsCombo
{
public:
	CArgosCompensation();
	virtual ~CArgosCompensation();

protected:
	//{{AFX_VIRTUAL(CArgosCompensation)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CArgosCompensation)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CArgosCompensation)
};


IMPLEMENT_DYNCREATE(CArgosCompensation, CTreeOptionsCombo)

CArgosCompensation::CArgosCompensation()
{
}

CArgosCompensation::~CArgosCompensation()
{
}

BEGIN_MESSAGE_MAP(CArgosCompensation, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CArgosCompensation)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

int CArgosCompensation::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;

	//Add strings to the combo
	AddString(GetResString(IDS_NO));
	for(int i = 9; i>0; i--)
		AddString(StrLine(GetResString(IDS_ARGOS_CREDIT),i));
	AddString(GetResString(IDS_ARGOS_UL_BAN));
	
	return 0;
}

#define UNHANDLING_ICO_INDEX 18
void SetTreeAC(CTreeOptionsCtrl &hCtrl,HTREEITEM &hItem, LPCTSTR Label,HTREEITEM Parent, LPCTSTR Info, int pLimit = 0){
	hItem = hCtrl.InsertItem(Label, UNHANDLING_ICO_INDEX, UNHANDLING_ICO_INDEX, Parent);
	hCtrl.AddComboBox(hItem,RUNTIME_CLASS(CArgosCompensation),0,(DWORD)pLimit);
	//hCtrl.SetItemSize(hItem,10);
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeAC(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/,HTREEITEM hItem, int& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_NO))
			nValue = 0;
		else if (sText == GetResString(IDS_ARGOS_UL_BAN))
			nValue = 10;
		else
			nValue = 10 - _tstoi(sText.Right(1));
	}else{
		switch(nValue){
		case 0: sText = GetResString(IDS_NO); break;
		case 10: sText = GetResString(IDS_ARGOS_UL_BAN); break;
		default: sText = StrLine(GetResString(IDS_ARGOS_CREDIT), 10 - nValue);
		}
		hCtrl->SetComboText(hItem, sText);
	}
}

//////////////////////////////////////////////////////////////////////////

class CDetectionLevel: public CTreeOptionsCombo
{
public:
	CDetectionLevel();
	virtual ~CDetectionLevel();

protected:
	//{{AFX_VIRTUAL(CDetectionLevel)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CDetectionLevel)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CDetectionLevel)
};


IMPLEMENT_DYNCREATE(CDetectionLevel, CTreeOptionsCombo)

CDetectionLevel::CDetectionLevel()
{
}

CDetectionLevel::~CDetectionLevel()
{
}

BEGIN_MESSAGE_MAP(CDetectionLevel, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CDetectionLevel)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CDetectionLevel::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_PRIOLOW));
	AddString(GetResString(IDS_PRIONORMAL));
	AddString(GetResString(IDS_PRIOHIGH));
	
	return 0;
}

void SetTreeDetectionLevel(CTreeOptionsCtrl &hCtrl,HTREEITEM &hItem, LPCTSTR Label,HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddComboBox(hItem,RUNTIME_CLASS(CDetectionLevel));
	//hCtrl.SetItemSize(hItem,10);
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeDetectionLevel(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/,HTREEITEM hItem, int& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_PRIOLOW))
			nValue = 3;
		else if (sText == GetResString(IDS_PRIOHIGH))
			nValue = 1;
		else
			nValue = 2;
	}else{
		switch(nValue){
		case 3: sText = GetResString(IDS_PRIOLOW); break;
		case 1: sText = GetResString(IDS_PRIOHIGH); break;
		default: sText = GetResString(IDS_PRIONORMAL); break;
		}
		hCtrl->SetComboText(hItem, sText);
	}
}

///////////////////////////////////////////////////////////////////////////////
// CPPgArgos dialog

IMPLEMENT_DYNAMIC(CPPgArgos, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgArgos, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
END_MESSAGE_MAP()

CPPgArgos::CPPgArgos()
	: CPropertyPage(CPPgArgos::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgArgos::~CPPgArgos()
{
}

void CPPgArgos::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;
	
	m_htiUseArgosSystem = NULL;
		m_htiArgosTrustTime = NULL;
		m_htiArgosProcessTime = NULL;
		m_htiArgosTrackTime = NULL;
		m_htiArgosGenericBanTime = NULL;
		m_htiCloseMaellaBackdoor = NULL;
		m_htiCreditCompensation = NULL;
		m_htiDontBanFriends = NULL;
		m_htiArgosLogLeechers = NULL;
	
	m_htiArgosLeecherDetection = NULL;
		m_htiArgosLeecherModDetection = NULL;
		m_htiArgosLeecherNickDetection = NULL;
		m_htiArgosDetectionLevel = NULL;
		m_htiArgosDetectionReload = NULL;
		m_htiArgosOpcodeDetection = NULL;
		m_htiArgosLeecherHashDetection = NULL;
		m_htiArgosOpCodeTime = NULL;
		m_htiArgosGPLBreakerPunishment = NULL;
		m_htiArgosHardLeecherPunishment = NULL;
		m_htiArgosNormalLeecherPunishment = NULL;
		m_htiArgosSoftLeecherPunishment = NULL;
		m_htiArgosBadModPunishment = NULL;
	m_htiArgosNickThiefDetection = NULL;
		m_htiPlainAntiNickThief = NULL;
		m_htiArgosNickThiefPunishment = NULL;
	m_htiArgosModThiefDetection = NULL;
		m_htiArgosModThiefPunishment = NULL;
	m_htiArgosHashThiefDetection = NULL;
		m_htiTrustUnArgosHashThief = NULL;
		m_htiArgosHashThiefPunishment = NULL;
	m_htiArgosCreditHackDetection = NULL;
		m_htiArgosCreditHackPunishment = NULL;
	m_htiHashChangeDetection = NULL;
		m_htiArgosHashChangedTime = NULL;
		m_htiTrustUnArgosHashChanged = NULL;
		m_htiArgosHashChangedPunishment = NULL;
	m_htiArgosGhostModDetection = NULL;
		m_htiArgosGhostModeTime = NULL;	
		m_htiTrustUnArgosGhostMode = NULL;
		m_htiArgosGhostModePunishment = NULL;
	m_htiArgosFakeClientDetection = NULL;
		m_htiArgosFakeClientPunishment = NULL;
	m_htiAgressionDetection = NULL;
		m_htiAgressionIntervals = NULL;
		m_htiAgressionThreshold = NULL;
		m_htiArgosAgressionBanTime = NULL;
		m_htiTrustUnArgosAgressiv = NULL;
		m_htiArgosAgressonPunishment = NULL;
	m_htiFileScannerDetection = NULL;
		m_htiArgosFileScannerTime = NULL;
		m_htiArgosFileScannerPunishment = NULL;
	m_htiFileFakerDetection = NULL;
		m_htiArgosFileFakerTime = NULL;
		m_htiArgosFileFakerPunishment = NULL;
	m_htiBadSenderDetection = NULL;
		m_htiArgosCorruptedSenderTime = NULL;
		m_htiArgosCorruptedSenderPunishment = NULL;
	m_htiRankFloodDetection = NULL;
		m_htiArgosRankFlooderTime = NULL;
		m_htiArgosRankFlooderPunishment = NULL;
	m_htiFailedDetection = NULL;
		m_htiFailedTries = NULL;
		m_htiFailedThreshold = NULL;
		m_htiArgosFailedTime = NULL;
		m_htiArgosFailedPunishment = NULL;
	m_htiXSExploitDetection = NULL;
		m_htiXSExploitIntervals = NULL;
		m_htiXSExploitThreshold = NULL;
		m_htiArgosXSExploitTime = NULL;
		m_htiArgosXSExploitPunishment = NULL;
	m_htiNickChangerDetection = NULL;
		m_htiNickChangeIntervals = NULL;
		m_htiNickChangeThreshold = NULL;
		m_htiArgosNickChangerTime = NULL;
		m_htiArgosNickChangerPunishment = NULL;
	m_htiModChangerDetection = NULL;
		m_htiModChangeIntervals = NULL;
		m_htiModChangeThreshold = NULL;
		m_htiArgosModChangerTime = NULL;
		m_htiArgosModChangerPunishment = NULL;
	m_htiNullNickDetection = NULL;
		m_htiArgosNullNickTime = NULL;
		m_htiArgosNullNickPunishment = NULL;
	m_htiSpamDetection = NULL;
		m_htiArgosSpamTime = NULL;
		m_htiArgosSpamPunishment = NULL;
	m_htiBadHelloDetection = NULL;
		m_htieMCryptDetection = NULL;
		m_htiArgosBadHelloTime = NULL;
		m_htiArgosBadHelloPunishment = NULL;
	m_htiBadProtDetection = NULL;
		m_htiArgosBadProtTime = NULL;
		m_htiArgosBadProtPunishment = NULL;
	m_htiDLPDetection = NULL;
		m_htiDLPDetectionReload = NULL;
}

void ReloadArgos(){
	theApp.argos->LoadFromFile();
}

void ReloadDLP(){
	theApp.argos->LoadDLPlibrary();
}

void CPPgArgos::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_ARGOS_TREECTRL, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		int iImgHandling = 8;
		int iImgUnHandling = 8;
		int iImgReload = 8;
		int iImgEngine = 8;
		if (piml){
			iImgHandling = piml->Add(CTempIconLoader(_T("BADHANDLING"))); ASSERT(iImgHandling == HANDLING_ICO_INDEX);
			iImgUnHandling = piml->Add(CTempIconLoader(_T("BADUNHANDLING"))); ASSERT(iImgUnHandling == UNHANDLING_ICO_INDEX);
			iImgReload = piml->Add(CTempIconLoader(_T("RELOAD")));
			iImgEngine = piml->Add(CTempIconLoader(_T("ARGOSENGINE")));
		}

		SetTreeCheck(m_ctrlTreeOptions,m_htiUseArgosSystem,GetResString(IDS_ARGOS_ENABLE),TVI_ROOT,GetResString(IDS_ARGOS_ENABLE_INFO),FALSE,m_bUseArgosSystem);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosProcessTime,GetResString(IDS_ARGOS_PROCESS_TIME), m_htiUseArgosSystem,GetResString(IDS_ARGOS_PROCESS_TIME_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosTrackTime,GetResString(IDS_ARGOS_TRACK_TIME), m_htiUseArgosSystem,GetResString(IDS_ARGOS_TRACK_TIME_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosGenericBanTime,GetResString(IDS_ARGOS_GENERIC_BAN_TIME), m_htiUseArgosSystem,GetResString(IDS_ARGOS_GENERIC_BAN_TIME_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosTrustTime,GetResString(IDS_ARGOS_TRUST_TIME), m_htiUseArgosSystem,GetResString(IDS_ARGOS_TRUST_TIME_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiCloseMaellaBackdoor,GetResString(IDS_ARGOS_CLOSE_BACKDOOR),m_htiUseArgosSystem,GetResString(IDS_ARGOS_CLOSE_BACKDOOR_INFO),TRUE,m_uCloseMaellaBackdoor);
			SetTreeAC(m_ctrlTreeOptions,m_htiCreditCompensation,GetResString(IDS_ARGOS_CREDIT_COMPENSATION),m_htiUseArgosSystem,GetResString(IDS_ARGOS_CREDIT_COMPENSATION_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiDontBanFriends,GetResString(IDS_ARGOS_DONT_BAN_FRIENDS),m_htiUseArgosSystem,GetResString(IDS_ARGOS_DONT_BAN_FRIENDS_INFO),TRUE,m_uDontBanFriends);
			SetTreeCheck(m_ctrlTreeOptions,m_htiArgosLogLeechers,GetResString(IDS_ARGOS_LOG),m_htiUseArgosSystem,GetResString(IDS_ARGOS_LOG_INFO),FALSE,m_bArgosLogLeechers);

		SetTreeGroup(m_ctrlTreeOptions,m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_LEECHER_DETECTION),iImgEngine, m_htiArgosLeecherDetection, GetResString(IDS_ARGOS_LEECHER_DETECTION_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiArgosLeecherModDetection,GetResString(IDS_ARGOS_LEECHER_MOD_DETECTION),m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_LEECHER_MOD_DETECTION_INFO),FALSE,m_bArgosLeecherModDetection);
			SetTreeCheck(m_ctrlTreeOptions,m_htiArgosLeecherNickDetection,GetResString(IDS_ARGOS_LEECHER_NICK_DETECTION),m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_LEECHER_NICK_DETECTION_INFO),TRUE,m_uArgosLeecherNickDetection);
			SetTreeCheck(m_ctrlTreeOptions,m_htiArgosOpcodeDetection,GetResString(IDS_ARGOS_OPCODE_DETECTION),m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_OPCODE_DETECTION_INFO),FALSE,m_bArgosOpcodeDetection);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosOpCodeTime,GetResString(IDS_ARGOS_OPCODE_TIME), m_htiArgosOpcodeDetection,GetResString(IDS_ARGOS_OPCODE_TIME_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiArgosLeecherHashDetection,GetResString(IDS_ARGOS_LEECHER_HASH_DETECTION),m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_LEECHER_HASH_DETECTION_INFO),FALSE,m_bArgosLeecherHashDetection);

			m_htiArgosDetectionReload = m_ctrlTreeOptions.InsertButton(GetResString(IDS_ARGOS_RELOAD), m_htiArgosLeecherDetection, &ReloadArgos);
				m_ctrlTreeOptions.SetItemIcons(m_htiArgosDetectionReload,iImgReload,iImgReload);
			m_ctrlTreeOptions.SetItemInfo(m_htiArgosDetectionReload,GetResString(IDS_ARGOS_RELOAD_INFO));

			SetTreeCheck(m_ctrlTreeOptions,m_htiDLPDetection,GetResString(IDS_ARGOS_DLP_DETECTION),m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_DLP_DETECTION_INFO),TRUE,m_uDLPDetection);
				SetTreeDetectionLevel(m_ctrlTreeOptions, m_htiArgosDetectionLevel,GetResString(IDS_ARGOS_LEVEL),m_htiDLPDetection,GetResString(IDS_ARGOS_LEVEL_INFO));
				m_htiDLPDetectionReload = m_ctrlTreeOptions.InsertButton(GetResString(IDS_ARGOS_DLP_RELOAD), m_htiDLPDetection, &ReloadDLP);
				m_ctrlTreeOptions.SetItemIcons(m_htiDLPDetectionReload,iImgReload,iImgReload);
				m_ctrlTreeOptions.SetItemInfo(m_htiDLPDetectionReload,GetResString(IDS_ARGOS_DLP_RELOAD_INFO));

			SetTreeAP(m_ctrlTreeOptions,m_htiArgosGPLBreakerPunishment,GetResString(IDS_ARGOS_BREAKER_PUNISHMENT), m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_BREAKER_PUNISHMENT_INFO),APL_ALL_AP);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosHardLeecherPunishment,GetResString(IDS_ARGOS_HARD_PUNISHMENT), m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_HARD_PUNISHMENT_INFO),APL_MAX_01_AP);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosNormalLeecherPunishment,GetResString(IDS_ARGOS_NORMAL_PUNISHMENT), m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_NORMAL_PUNISHMENT_INFO),APL_MAX_05_AP);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosSoftLeecherPunishment,GetResString(IDS_ARGOS_SOFT_PUNISHMENT), m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_SOFT_PUNISHMENT_INFO),APL_MAX_08_AP);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosBadModPunishment,GetResString(IDS_ARGOS_BAD_MOD_PUNISHMENT), m_htiArgosLeecherDetection,GetResString(IDS_ARGOS_BAD_MOD_PUNISHMENT_INFO),APL_MAX_09_AP + APL_NO_BAN);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosNickThiefDetection,GetResString(IDS_ARGOS_NICK_THIEF_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_NICK_THIEF_DETECTION_INFO),FALSE,m_bArgosNickThiefDetection);
			SetTreeCheck(m_ctrlTreeOptions,m_htiPlainAntiNickThief,GetResString(IDS_ARGOS_PLAIN_ANTI_NICK_THIEF),m_htiArgosNickThiefDetection,GetResString(IDS_ARGOS_PLAIN_ANTI_NICK_THIEF_INFO),FALSE,m_bPlainAntiNickThief);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosNickThiefPunishment,GetResString(IDS_ARGOS_NICK_THIEF_PUNISHMENT), m_htiArgosNickThiefDetection,GetResString(IDS_ARGOS_NICK_THIEF_PUNISHMENT_INFO),APL_MAX_04_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosModThiefDetection,GetResString(IDS_ARGOS_MOD_THIEF_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_MOD_THIEF_DETECTION_INFO),FALSE,m_bArgosModThiefDetection);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosModThiefPunishment,GetResString(IDS_ARGOS_MOD_THIEF_PUNISHMENT), m_htiArgosModThiefDetection,GetResString(IDS_ARGOS_MOD_THIEF_PUNISHMENT_INFO),APL_MAX_03_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosHashThiefDetection,GetResString(IDS_ARGOS_HASH_THIEF_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_HASH_THIEF_DETECTION_INFO),FALSE,m_bArgosHashThiefDetection);
			SetTreeCheck(m_ctrlTreeOptions,m_htiTrustUnArgosHashThief,GetResString(IDS_ARGOS_TRUST_UNARGOS_HASH_THIEF),m_htiArgosHashThiefDetection,GetResString(IDS_ARGOS_TRUST_UNARGOS_HASH_THIEF_INFO),FALSE,m_bTrustUnArgosHashThief);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosHashThiefPunishment,GetResString(IDS_ARGOS_HASH_THIEF_PUNISHMENT), m_htiArgosHashThiefDetection,GetResString(IDS_ARGOS_HASH_THIEF_PUNISHMENT_INFO),APL_MAX_01_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosCreditHackDetection,GetResString(IDS_ARGOS_CREDIT_HACK_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_CREDIT_HACK_DETECTION_INFO),FALSE,m_bArgosCreditHackDetection);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosCreditHackPunishment,GetResString(IDS_ARGOS_CREDIT_HACK_PUNISHMENT), m_htiArgosCreditHackDetection,GetResString(IDS_ARGOS_CREDIT_HACK_PUNISHMENT_INFO),APL_MAX_01_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiHashChangeDetection,GetResString(IDS_ARGOS_HASH_CHANGER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_HASH_CHANGER_DETECTION_INFO),FALSE,m_bHashChangeDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosHashChangedTime,GetResString(IDS_ARGOS_HASH_CHANGER_TIME), m_htiHashChangeDetection,GetResString(IDS_ARGOS_HASH_CHANGER_TIME_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiTrustUnArgosHashChanged,GetResString(IDS_ARGOS_TRUST_UNARGOS_HASH_CHANGER),m_htiHashChangeDetection,GetResString(IDS_ARGOS_TRUST_UNARGOS_HASH_CHANGER_INFO),FALSE,m_bTrustUnArgosHashChanged);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosHashChangedPunishment,GetResString(IDS_ARGOS_HASH_CHANGER_PUNISHMENT), m_htiHashChangeDetection,GetResString(IDS_ARGOS_HASH_CHANGER_PUNISHMENT_INFO),APL_MAX_07_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosGhostModDetection,GetResString(IDS_ARGOS_GHOST_MOD_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_GHOST_MOD_DETECTION_INFO),FALSE,m_bArgosGhostModDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosGhostModeTime,GetResString(IDS_ARGOS_GHOST_MOD_TIME), m_htiArgosGhostModDetection,GetResString(IDS_ARGOS_GHOST_MOD_TIME_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiTrustUnArgosGhostMode,GetResString(IDS_ARGOS_TRUST_UNARGOS_GHOST_MOD),m_htiArgosGhostModDetection,GetResString(IDS_ARGOS_TRUST_UNARGOS_GHOST_MOD_INFO),FALSE,m_bTrustUnArgosGhostMode);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosGhostModePunishment,GetResString(IDS_ARGOS_GHOST_MOD_PUNISHMENT), m_htiArgosGhostModDetection,GetResString(IDS_ARGOS_GHOST_MOD_PUNISHMENT_INFO),APL_MAX_09_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiArgosFakeClientDetection,GetResString(IDS_ARGOS_FAKE_CLIENT_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_FAKE_CLIENT_DETECTION_INFO),TRUE,m_uArgosFakeClientDetection);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosFakeClientPunishment,GetResString(IDS_ARGOS_FAKE_CLIENT_PUNISHMENT), m_htiArgosFakeClientDetection,GetResString(IDS_ARGOS_FAKE_CLIENT_PUNISHMENT_INFO),APL_MAX_03_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiAgressionDetection,GetResString(IDS_ARGOS_AGRESSION_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_AGRESSION_DETECTION_INFO),TRUE,m_uAgressionDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiAgressionIntervals,GetResString(IDS_ARGOS_AGRESSION_INTERVALS), m_htiAgressionDetection,GetResString(IDS_ARGOS_AGRESSION_INTERVALS_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiAgressionThreshold,GetResString(IDS_ARGOS_AGRESSION_THRESHOLD), m_htiAgressionDetection,GetResString(IDS_ARGOS_AGRESSION_THRESHOLD_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosAgressionBanTime,GetResString(IDS_ARGOS_AGRESSION_TIME), m_htiAgressionDetection,GetResString(IDS_ARGOS_AGRESSION_TIME_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiTrustUnArgosAgressiv,GetResString(IDS_ARGOS_TRUST_UNARGOS_AGRESSION),m_htiAgressionDetection,GetResString(IDS_ARGOS_TRUST_UNARGOS_AGRESSION_INFO),FALSE,m_bTrustUnArgosAgressiv);
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosAgressonPunishment,GetResString(IDS_ARGOS_AGRESSON_PUNISHMENT), m_htiAgressionDetection,GetResString(IDS_ARGOS_AGRESSON_PUNISHMENT_INFO),APL_MAX_05_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiFileScannerDetection,GetResString(IDS_ARGOS_FILE_SCANNER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_FILE_SCANNER_DETECTION_INFO),FALSE,m_bFileScannerDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosFileScannerTime,GetResString(IDS_ARGOS_FILE_SCANNER_TIME), m_htiFileScannerDetection,GetResString(IDS_ARGOS_FILE_SCANNER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosFileScannerPunishment,GetResString(IDS_ARGOS_FILE_SCANNER_PUNISHMENT), m_htiFileScannerDetection,GetResString(IDS_ARGOS_FILE_SCANNER_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiFileFakerDetection,GetResString(IDS_ARGOS_FILE_FAKER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_FILE_FAKER_DETECTION_INFO),FALSE,m_bFileFakerDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosFileFakerTime,GetResString(IDS_ARGOS_FILE_FAKER_TIME), m_htiFileFakerDetection,GetResString(IDS_ARGOS_FILE_FAKER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosFileFakerPunishment,GetResString(IDS_ARGOS_FILE_FAKER_PUNISHMENT), m_htiFileFakerDetection,GetResString(IDS_ARGOS_FILE_FAKER_PUNISHMENT_INFO),APL_MAX_05_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiBadSenderDetection,GetResString(IDS_ARGOS_BAD_SENDER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_BAD_SENDER_DETECTION_INFO),FALSE,m_bBadSenderDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosCorruptedSenderTime,GetResString(IDS_ARGOS_BAD_SENDER_TIME), m_htiBadSenderDetection,GetResString(IDS_ARGOS_BAD_SENDER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosCorruptedSenderPunishment,GetResString(IDS_ARGOS_BAD_SENDER_PUNISHMENT), m_htiBadSenderDetection,GetResString(IDS_ARGOS_BAD_SENDER_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiRankFloodDetection,GetResString(IDS_ARGOS_RANK_FLOODER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_RANK_FLOODER_DETECTION_INFO),FALSE,m_bRankFloodDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosRankFlooderTime,GetResString(IDS_ARGOS_RANK_FLOODER_TIME), m_htiRankFloodDetection,GetResString(IDS_ARGOS_RANK_FLOODER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosRankFlooderPunishment,GetResString(IDS_ARGOS_RANK_FLOODER_PUNISHMENT), m_htiRankFloodDetection,GetResString(IDS_ARGOS_RANK_FLOODER_PUNISHMENT_INFO),APL_NO_AP_UL);

		SetTreeCheck(m_ctrlTreeOptions,m_htiFailedDetection,GetResString(IDS_ARGOS_FAILED_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_FAILED_DETECTION_INFO),FALSE,m_bFailedDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiFailedThreshold,GetResString(IDS_ARGOS_FAILED_THRESHOLD), m_htiFailedDetection,GetResString(IDS_ARGOS_FAILED_THRESHOLD_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiFailedTries,GetResString(IDS_ARGOS_FAILED_TRIES), m_htiFailedDetection,GetResString(IDS_ARGOS_FAILED_TRIES_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosFailedTime,GetResString(IDS_ARGOS_FAILED_TIME), m_htiFailedDetection,GetResString(IDS_ARGOS_FAILED_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosFailedPunishment,GetResString(IDS_ARGOS_FAILED_PUNISHMENT), m_htiFailedDetection,GetResString(IDS_ARGOS_FAILED_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiXSExploitDetection,GetResString(IDS_ARGOS_XS_EXPLOIT_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_XS_EXPLOIT_DETECTION_INFO),FALSE,m_bXSExploitDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSExploitIntervals,GetResString(IDS_ARGOS_XS_EXPLOIT_INTERVALS), m_htiXSExploitDetection,GetResString(IDS_ARGOS_XS_EXPLOIT_INTERVALS_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSExploitThreshold,GetResString(IDS_ARGOS_XS_EXPLOIT_THRESHOLD), m_htiXSExploitDetection,GetResString(IDS_ARGOS_XS_EXPLOIT_THRESHOLD_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosXSExploitTime,GetResString(IDS_ARGOS_XS_EXPLOIT_TIME), m_htiXSExploitDetection,GetResString(IDS_ARGOS_XS_EXPLOIT_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosXSExploitPunishment,GetResString(IDS_ARGOS_XS_EXPLOIT_PUNISHMENT), m_htiXSExploitDetection,GetResString(IDS_ARGOS_XS_EXPLOIT_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiNickChangerDetection,GetResString(IDS_ARGOS_NICK_CHANGER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_NICK_CHANGER_DETECTION_INFO),FALSE,m_bNickChangerDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiNickChangeIntervals,GetResString(IDS_ARGOS_NICK_CHANGER_INTERVALS), m_htiNickChangerDetection,GetResString(IDS_ARGOS_NICK_CHANGER_INTERVALS_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiNickChangeThreshold,GetResString(IDS_ARGOS_NICK_CHANGER_THRESHOLD), m_htiNickChangerDetection,GetResString(IDS_ARGOS_NICK_CHANGER_THRESHOLD_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosNickChangerTime,GetResString(IDS_ARGOS_NICK_CHANGER_TIME), m_htiNickChangerDetection,GetResString(IDS_ARGOS_NICK_CHANGER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosNickChangerPunishment,GetResString(IDS_ARGOS_NICK_CHANGER_PUNISHMENT), m_htiNickChangerDetection,GetResString(IDS_ARGOS_NICK_CHANGER_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiModChangerDetection,GetResString(IDS_ARGOS_MOD_CHANGER_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_MOD_CHANGER_DETECTION_INFO),FALSE,m_bModChangerDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiModChangeIntervals,GetResString(IDS_ARGOS_MOD_CHANGER_INTERVALS), m_htiModChangerDetection,GetResString(IDS_ARGOS_MOD_CHANGER_INTERVALS_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiModChangeThreshold,GetResString(IDS_ARGOS_MOD_CHANGER_THRESHOLD), m_htiModChangerDetection,GetResString(IDS_ARGOS_MOD_CHANGER_THRESHOLD_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosModChangerTime,GetResString(IDS_ARGOS_MOD_CHANGER_TIME), m_htiModChangerDetection,GetResString(IDS_ARGOS_MOD_CHANGER_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosModChangerPunishment,GetResString(IDS_ARGOS_MOD_CHANGER_PUNISHMENT), m_htiModChangerDetection,GetResString(IDS_ARGOS_MOD_CHANGER_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiNullNickDetection,GetResString(IDS_ARGOS_NULL_NICK_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_NULL_NICK_DETECTION_INFO),FALSE,m_bNullNickDetection);
		SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosNullNickTime,GetResString(IDS_ARGOS_NULL_NICK_TIME), m_htiNullNickDetection,GetResString(IDS_ARGOS_NULL_NICK_TIME_INFO));
		SetTreeAP(m_ctrlTreeOptions,m_htiArgosNullNickPunishment,GetResString(IDS_ARGOS_NULL_NICK_PUNISHMENT), m_htiNullNickDetection,GetResString(IDS_ARGOS_NULL_NICK_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiSpamDetection,GetResString(IDS_ARGOS_SPAM_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_SPAM_DETECTION_INFO),FALSE,m_bSpamDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosSpamTime,GetResString(IDS_ARGOS_SPAM_TIME), m_htiSpamDetection,GetResString(IDS_ARGOS_SPAM_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosSpamPunishment,GetResString(IDS_ARGOS_SPAM_PUNISHMENT), m_htiSpamDetection,GetResString(IDS_ARGOS_SPAM_PUNISHMENT_INFO),APL_BAN_ONLY);

		SetTreeCheck(m_ctrlTreeOptions,m_htiBadHelloDetection,GetResString(IDS_ARGOS_BAD_HELLO_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_BAD_HELLO_DETECTION_INFO),FALSE,m_bBadHelloDetection);
			SetTreeCheck(m_ctrlTreeOptions,m_htieMCryptDetection,GetResString(IDS_ARGOS_EMCRYPT_DETECTION),m_htiBadHelloDetection,GetResString(IDS_ARGOS_EMCRYPT_DETECTION_INFO),TRUE,m_ueMCryptDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosBadHelloTime,GetResString(IDS_ARGOS_BAD_HELLO_TIME), m_htiBadHelloDetection,GetResString(IDS_ARGOS_BAD_HELLO_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosBadHelloPunishment,GetResString(IDS_ARGOS_BAD_HELLO_PUNISHMENT), m_htiBadHelloDetection,GetResString(IDS_ARGOS_BAD_HELLO_PUNISHMENT_INFO),APL_MAX_03_AP);

		SetTreeCheck(m_ctrlTreeOptions,m_htiBadProtDetection,GetResString(IDS_ARGOS_BAD_PROT_DETECTION),TVI_ROOT,GetResString(IDS_ARGOS_BAD_PROT_DETECTION_INFO),FALSE,m_bBadProtDetection);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiArgosBadProtTime,GetResString(IDS_ARGOS_BAD_PROT_TIME), m_htiBadProtDetection,GetResString(IDS_ARGOS_BAD_PROT_TIME_INFO));
			SetTreeAP(m_ctrlTreeOptions,m_htiArgosBadProtPunishment,GetResString(IDS_ARGOS_BAD_PROT_PUNISHMENT), m_htiBadProtDetection,GetResString(IDS_ARGOS_BAD_PROT_PUNISHMENT_INFO),APL_MAX_03_AP);

		CheckEnable();

		m_bInitializedTreeOpts = true;
	}

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiUseArgosSystem, m_bUseArgosSystem);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosProcessTime, m_iArgosProcessTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosTrackTime, m_iArgosTrackTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosGenericBanTime, m_iArgosGenericBanTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosTrustTime, m_iArgosTrustTime);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiCloseMaellaBackdoor, m_uCloseMaellaBackdoor);
		DDX_TreeAC(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiCreditCompensation,m_iCreditCompensation);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiDontBanFriends, m_uDontBanFriends);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosLogLeechers, m_bArgosLogLeechers);

		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosLeecherModDetection, m_bArgosLeecherModDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosLeecherNickDetection, m_uArgosLeecherNickDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosOpcodeDetection, m_bArgosOpcodeDetection);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosOpCodeTime, m_iArgosOpCodeTime);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosLeecherHashDetection, m_bArgosLeecherHashDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiDLPDetection, m_uDLPDetection);

		DDX_TreeDetectionLevel(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosDetectionLevel, m_iArgosDetectionLevel);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosGPLBreakerPunishment,m_iArgosGPLBreakerPunishment);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosHardLeecherPunishment,m_iArgosHardLeecherPunishment);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosNormalLeecherPunishment,m_iArgosNormalLeecherPunishment);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosSoftLeecherPunishment,m_iArgosSoftLeecherPunishment);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosBadModPunishment,m_iArgosBadModPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosNickThiefDetection, m_bArgosNickThiefDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiPlainAntiNickThief, m_bPlainAntiNickThief);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosNickThiefPunishment,m_iArgosNickThiefPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosModThiefDetection, m_bArgosModThiefDetection);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosModThiefPunishment,m_iArgosModThiefPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosHashThiefDetection, m_bArgosHashThiefDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiTrustUnArgosHashThief, m_bTrustUnArgosHashThief);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosHashThiefPunishment,m_iArgosHashThiefPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosCreditHackDetection, m_bArgosCreditHackDetection);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosCreditHackPunishment,m_iArgosCreditHackPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiHashChangeDetection, m_bHashChangeDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosHashChangedTime, m_iArgosHashChangedTime);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiTrustUnArgosHashChanged, m_bTrustUnArgosHashChanged);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosHashChangedPunishment,m_iArgosHashChangedPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosGhostModDetection, m_bArgosGhostModDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosGhostModeTime, m_iArgosGhostModeTime);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiTrustUnArgosGhostMode, m_bTrustUnArgosGhostMode);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosGhostModePunishment,m_iArgosGhostModePunishment);

		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosFakeClientDetection, m_uArgosFakeClientDetection);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosFakeClientPunishment,m_iArgosFakeClientPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiAgressionDetection, m_uAgressionDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiAgressionIntervals, m_iAgressionIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiAgressionThreshold, m_iAgressionThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosAgressionBanTime, m_iArgosAgressionBanTime);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiTrustUnArgosAgressiv, m_bTrustUnArgosAgressiv);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosAgressonPunishment,m_iArgosAgressonPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiFileScannerDetection, m_bFileScannerDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosFileScannerTime, m_iArgosFileScannerTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosFileScannerPunishment,m_iArgosFileScannerPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiFileFakerDetection, m_bFileFakerDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosFileFakerTime, m_iArgosFileFakerTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosFileFakerPunishment,m_iArgosFileFakerPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiBadSenderDetection, m_bBadSenderDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosCorruptedSenderTime, m_iArgosCorruptedSenderTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosCorruptedSenderPunishment,m_iArgosCorruptedSenderPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiRankFloodDetection, m_bRankFloodDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosRankFlooderTime, m_iArgosRankFlooderTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosRankFlooderPunishment,m_iArgosRankFlooderPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiFailedDetection, m_bFailedDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiFailedThreshold, m_iFailedThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiFailedTries, m_iFailedTries);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosFailedTime, m_iArgosFailedTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosFailedPunishment,m_iArgosFailedPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiXSExploitDetection, m_bXSExploitDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiXSExploitIntervals, m_iXSExploitIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiXSExploitThreshold, m_iXSExploitThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosXSExploitTime, m_iArgosXSExploitTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosXSExploitPunishment,m_iArgosXSExploitPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiNickChangerDetection, m_bNickChangerDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiNickChangeIntervals, m_iNickChangeIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiNickChangeThreshold, m_iNickChangeThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosNickChangerTime, m_iArgosNickChangerTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosNickChangerPunishment,m_iArgosNickChangerPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiModChangerDetection, m_bModChangerDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiModChangeIntervals, m_iModChangeIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiModChangeThreshold, m_iModChangeThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosModChangerTime, m_iArgosModChangerTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosModChangerPunishment,m_iArgosModChangerPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiNullNickDetection, m_bNullNickDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosNullNickTime, m_iArgosNullNickTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosNullNickPunishment,m_iArgosNullNickPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiSpamDetection, m_bSpamDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosSpamTime, m_iArgosSpamTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosSpamPunishment,m_iArgosSpamPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiBadHelloDetection, m_bBadHelloDetection);
		DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htieMCryptDetection, m_ueMCryptDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosBadHelloTime, m_iArgosBadHelloTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosBadHelloPunishment,m_iArgosBadHelloPunishment);

	DDX_TreeCheck(pDX, IDC_PRF_ARGOS_TREECTRL, m_htiBadProtDetection, m_bBadProtDetection);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL, m_htiArgosBadProtTime, m_iArgosBadProtTime);
		DDX_TreeAP(&m_ctrlTreeOptions, pDX, IDC_PRF_ARGOS_TREECTRL,m_htiArgosBadProtPunishment,m_iArgosBadProtPunishment);
}

BOOL CPPgArgos::OnInitDialog()
{
	LoadSettings();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	
	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgArgos::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/

	m_bUseArgosSystem = thePrefs.m_bUseArgosSystem;

	m_iCreditCompensation = thePrefs.m_iCreditCompensation;

	m_bTrustUnArgosHashThief = thePrefs.m_bTrustUnArgosHashThief;
	m_bTrustUnArgosHashChanged = thePrefs.m_bTrustUnArgosHashChanged;
	m_bTrustUnArgosGhostMode = thePrefs.m_bTrustUnArgosGhostMode;
	m_bTrustUnArgosAgressiv = thePrefs.m_bTrustUnArgosAgressiv;
	m_iArgosTrustTime = thePrefs.m_iArgosTrustTime;

	m_uCloseMaellaBackdoor = thePrefs.m_uCloseMaellaBackdoor;

	m_uDontBanFriends = thePrefs.m_uDontBanFriends;

	m_iArgosProcessTime = thePrefs.m_iArgosProcessTime;
	m_iArgosTrackTime = thePrefs.m_iArgosTrackTime;
	m_iArgosGenericBanTime = thePrefs.m_iArgosGenericBanTime;
	m_iArgosCorruptedSenderTime = thePrefs.m_iArgosCorruptedSenderTime;
	m_iArgosFileScannerTime = thePrefs.m_iArgosFileScannerTime;
	m_iArgosFileFakerTime = thePrefs.m_iArgosFileFakerTime;
	m_iArgosAgressionBanTime = thePrefs.m_iArgosAgressionBanTime;
	m_iArgosOpCodeTime = thePrefs.m_iArgosOpCodeTime;
	m_iArgosHashChangedTime = thePrefs.m_iArgosHashChangedTime;
	m_iArgosRankFlooderTime = thePrefs.m_iArgosRankFlooderTime;
	m_iArgosGhostModeTime = thePrefs.m_iArgosGhostModeTime;
	m_iArgosFailedTime = thePrefs.m_iArgosFailedTime;
	m_iArgosXSExploitTime = thePrefs.m_iArgosXSExploitTime;
	m_iArgosNickChangerTime = thePrefs.m_iArgosNickChangerTime;
	m_iArgosModChangerTime = thePrefs.m_iArgosModChangerTime;
	m_iArgosNullNickTime = thePrefs.m_iArgosNullNickTime;
	m_iArgosSpamTime = thePrefs.m_iArgosSpamTime;
	m_iArgosBadHelloTime = thePrefs.m_iArgosBadHelloTime;
	m_iArgosBadProtTime = thePrefs.m_iArgosBadProtTime;

	m_iArgosGPLBreakerPunishment = thePrefs.m_iArgosGPLBreakerPunishment;
	m_iArgosHardLeecherPunishment = thePrefs.m_iArgosHardLeecherPunishment;
	m_iArgosNormalLeecherPunishment = thePrefs.m_iArgosNormalLeecherPunishment;
	m_iArgosSoftLeecherPunishment = thePrefs.m_iArgosSoftLeecherPunishment;
	m_iArgosBadModPunishment = thePrefs.m_iArgosBadModPunishment;
	m_iArgosNickThiefPunishment = thePrefs.m_iArgosNickThiefPunishment;
	m_iArgosModThiefPunishment = thePrefs.m_iArgosModThiefPunishment;
	m_iArgosHashThiefPunishment = thePrefs.m_iArgosHashThiefPunishment;
	m_iArgosCreditHackPunishment = thePrefs.m_iArgosCreditHackPunishment;
	m_iArgosHashChangedPunishment = thePrefs.m_iArgosHashChangedPunishment;
	m_iArgosGhostModePunishment = thePrefs.m_iArgosGhostModePunishment;
	m_iArgosFakeClientPunishment = thePrefs.m_iArgosFakeClientPunishment;
	m_iArgosAgressonPunishment = thePrefs.m_iArgosAgressonPunishment;
	m_iArgosFileScannerPunishment = thePrefs.m_iArgosFileScannerPunishment;
	m_iArgosFileFakerPunishment = thePrefs.m_iArgosFileFakerPunishment;
	m_iArgosCorruptedSenderPunishment = thePrefs.m_iArgosCorruptedSenderPunishment;
	m_iArgosRankFlooderPunishment = thePrefs.m_iArgosRankFlooderPunishment;
	m_iArgosFailedPunishment = thePrefs.m_iArgosFailedPunishment;
	m_iArgosXSExploitPunishment = thePrefs.m_iArgosXSExploitPunishment;
	m_iArgosNickChangerPunishment = thePrefs.m_iArgosNickChangerPunishment;
	m_iArgosModChangerPunishment = thePrefs.m_iArgosModChangerPunishment;
	m_iArgosNullNickPunishment = thePrefs.m_iArgosNullNickPunishment;
	m_iArgosSpamPunishment = thePrefs.m_iArgosSpamPunishment;
	m_iArgosBadHelloPunishment = thePrefs.m_iArgosBadHelloPunishment;
	m_iArgosBadProtPunishment = thePrefs.m_iArgosBadProtPunishment;

	m_bArgosLeecherModDetection = thePrefs.m_bArgosLeecherModDetection;
	m_uArgosLeecherNickDetection = thePrefs.m_uArgosLeecherNickDetection;
	m_iArgosDetectionLevel = thePrefs.m_iArgosDetectionLevel;
	m_bArgosOpcodeDetection = thePrefs.m_bArgosOpcodeDetection;
	m_bArgosLeecherHashDetection = thePrefs.m_bArgosLeecherHashDetection;
	m_bArgosNickThiefDetection = thePrefs.m_bArgosNickThiefDetection;
	m_bPlainAntiNickThief = thePrefs.m_bPlainAntiNickThief;
	m_bArgosModThiefDetection = thePrefs.m_bArgosModThiefDetection;
	m_bArgosHashThiefDetection = thePrefs.m_bArgosHashThiefDetection;
	m_bArgosCreditHackDetection = thePrefs.m_bArgosCreditHackDetection;
	m_bHashChangeDetection = thePrefs.m_bHashChangeDetection;
	m_bArgosGhostModDetection = thePrefs.m_bArgosGhostModDetection;
	m_uArgosFakeClientDetection = thePrefs.m_uArgosFakeClientDetection;
	m_uAgressionDetection = thePrefs.m_uAgressionDetection;
	m_iAgressionIntervals = thePrefs.m_iAgressionIntervals;
	m_iAgressionThreshold = thePrefs.m_iAgressionThreshold;
	m_bFileScannerDetection = thePrefs.m_bFileScannerDetection;
	m_bFileFakerDetection = thePrefs.m_bFileFakerDetection;
	m_bBadSenderDetection = thePrefs.m_bBadSenderDetection;
	m_bRankFloodDetection = thePrefs.m_bRankFloodDetection;
	m_bFailedDetection = thePrefs.m_bFailedDetection;
	m_iFailedTries = thePrefs.m_iFailedTries;
	m_iFailedThreshold = thePrefs.m_iFailedThreshold;
	m_bXSExploitDetection = thePrefs.m_bXSExploitDetection;
	m_iXSExploitIntervals = thePrefs.m_iXSExploitIntervals;
	m_iXSExploitThreshold = thePrefs.m_iXSExploitThreshold;
	m_bNickChangerDetection = thePrefs.m_bNickChangerDetection;
	m_iNickChangeIntervals = thePrefs.m_iNickChangeIntervals;
	m_iNickChangeThreshold = thePrefs.m_iNickChangeThreshold;
	m_bModChangerDetection = thePrefs.m_bModChangerDetection;
	m_iModChangeIntervals = thePrefs.m_iModChangeIntervals;
	m_iModChangeThreshold = thePrefs.m_iModChangeThreshold;
	m_bNullNickDetection = thePrefs.m_bNullNickDetection;
	m_bSpamDetection = thePrefs.m_bSpamDetection;
	m_bBadHelloDetection = thePrefs.m_bBadHelloDetection;
	m_ueMCryptDetection = thePrefs.m_ueMCryptDetection;
	m_bBadProtDetection = thePrefs.m_bBadProtDetection;
	m_uDLPDetection = thePrefs.m_uDLPDetection;

	m_bArgosLogLeechers = thePrefs.m_bArgosLogLeechers;
}

BOOL CPPgArgos::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	/*
	* Globale Einstellungen Speichern
	*/

	bool bUseArgosEngine = (m_bArgosLeecherModDetection || m_uArgosLeecherNickDetection || m_bArgosOpcodeDetection || m_bArgosLeecherHashDetection || (m_uDLPDetection == TRUE));

	bool bReloadArgos = ((thePrefs.m_bUseArgosSystem != m_bUseArgosSystem 

		|| thePrefs.m_bArgosLeecherModDetection != m_bArgosLeecherModDetection 
		|| thePrefs.m_uArgosLeecherNickDetection != m_uArgosLeecherNickDetection 
		|| thePrefs.m_bArgosOpcodeDetection != m_bArgosOpcodeDetection 
		|| thePrefs.m_bArgosLeecherHashDetection != m_bArgosLeecherHashDetection
		|| (thePrefs.m_uDLPDetection == TRUE) != (m_uDLPDetection == TRUE)

		|| thePrefs.m_uDLPDetection != m_uDLPDetection

		|| thePrefs.m_iArgosDetectionLevel != m_iArgosDetectionLevel)

		&& bUseArgosEngine);

	if(thePrefs.m_bUseArgosSystem != m_bUseArgosSystem){
		if(m_bUseArgosSystem){
			theApp.emuledlg->transferwnd->clientlistctrl.ShowColumn(9);
			theApp.emuledlg->transferwnd->queuelistctrl.ShowColumn(13);
			theApp.emuledlg->transferwnd->uploadlistctrl.ShowColumn(13);
			theApp.emuledlg->transferwnd->downloadclientsctrl.ShowColumn(9);
		}else{
			theApp.emuledlg->transferwnd->clientlistctrl.HideColumn(9);
			theApp.emuledlg->transferwnd->queuelistctrl.HideColumn(13);
			theApp.emuledlg->transferwnd->uploadlistctrl.HideColumn(13);
			theApp.emuledlg->transferwnd->downloadclientsctrl.HideColumn(9);
		}
		}

	thePrefs.m_bUseArgosSystem = m_bUseArgosSystem;

	thePrefs.m_iCreditCompensation = m_iCreditCompensation;

	thePrefs.m_bTrustUnArgosHashThief = m_bTrustUnArgosHashThief;
	thePrefs.m_bTrustUnArgosHashChanged = m_bTrustUnArgosHashChanged;
	thePrefs.m_bTrustUnArgosGhostMode = m_bTrustUnArgosGhostMode;
	thePrefs.m_bTrustUnArgosAgressiv = m_bTrustUnArgosAgressiv;
	thePrefs.m_iArgosTrustTime = m_iArgosTrustTime;

	thePrefs.m_uCloseMaellaBackdoor = m_uCloseMaellaBackdoor;

	thePrefs.m_uDontBanFriends = m_uDontBanFriends;

	thePrefs.m_iArgosProcessTime = m_iArgosProcessTime;
	thePrefs.m_iArgosTrackTime = m_iArgosTrackTime;
	thePrefs.m_iArgosGenericBanTime = m_iArgosGenericBanTime;
	thePrefs.m_iArgosCorruptedSenderTime = m_iArgosCorruptedSenderTime;
	thePrefs.m_iArgosFileScannerTime = m_iArgosFileScannerTime;
	thePrefs.m_iArgosFileFakerTime = m_iArgosFileFakerTime;
	thePrefs.m_iArgosAgressionBanTime = m_iArgosAgressionBanTime;
	thePrefs.m_iArgosOpCodeTime = m_iArgosOpCodeTime;
	thePrefs.m_iArgosHashChangedTime = m_iArgosHashChangedTime;
	thePrefs.m_iArgosRankFlooderTime = m_iArgosRankFlooderTime;
	thePrefs.m_iArgosGhostModeTime = m_iArgosGhostModeTime;
	thePrefs.m_iArgosFailedTime = m_iArgosFailedTime;
	thePrefs.m_iArgosXSExploitTime = m_iArgosXSExploitTime;
	thePrefs.m_iArgosNickChangerTime = m_iArgosNickChangerTime;
	thePrefs.m_iArgosModChangerTime = m_iArgosModChangerTime;
	thePrefs.m_iArgosNullNickTime = m_iArgosNullNickTime;
	thePrefs.m_iArgosSpamTime = m_iArgosSpamTime;
	thePrefs.m_iArgosBadHelloTime = m_iArgosBadHelloTime;
	thePrefs.m_iArgosBadProtTime = m_iArgosBadProtTime;

	thePrefs.m_iArgosGPLBreakerPunishment = m_iArgosGPLBreakerPunishment;
	thePrefs.m_iArgosHardLeecherPunishment = m_iArgosHardLeecherPunishment;
	thePrefs.m_iArgosNormalLeecherPunishment = m_iArgosNormalLeecherPunishment;
	thePrefs.m_iArgosSoftLeecherPunishment = m_iArgosSoftLeecherPunishment;
	thePrefs.m_iArgosBadModPunishment = m_iArgosBadModPunishment;
	thePrefs.m_iArgosNickThiefPunishment = m_iArgosNickThiefPunishment;
	thePrefs.m_iArgosModThiefPunishment = m_iArgosModThiefPunishment;
	thePrefs.m_iArgosHashThiefPunishment = m_iArgosHashThiefPunishment;
	thePrefs.m_iArgosCreditHackPunishment = m_iArgosCreditHackPunishment;
	thePrefs.m_iArgosHashChangedPunishment = m_iArgosHashChangedPunishment;
	thePrefs.m_iArgosGhostModePunishment = m_iArgosGhostModePunishment;
	thePrefs.m_iArgosFakeClientPunishment = m_iArgosFakeClientPunishment;
	thePrefs.m_iArgosAgressonPunishment = m_iArgosAgressonPunishment;
	thePrefs.m_iArgosFileScannerPunishment = m_iArgosFileScannerPunishment;
	thePrefs.m_iArgosFileFakerPunishment = m_iArgosFileFakerPunishment;
	thePrefs.m_iArgosCorruptedSenderPunishment = m_iArgosCorruptedSenderPunishment;
	thePrefs.m_iArgosRankFlooderPunishment = m_iArgosRankFlooderPunishment;
	thePrefs.m_iArgosFailedPunishment = m_iArgosFailedPunishment;
	thePrefs.m_iArgosXSExploitPunishment = m_iArgosXSExploitPunishment;
	thePrefs.m_iArgosNickChangerPunishment = m_iArgosNickChangerPunishment;
	thePrefs.m_iArgosModChangerPunishment = m_iArgosModChangerPunishment;
	thePrefs.m_iArgosNullNickPunishment = m_iArgosNullNickPunishment;
	thePrefs.m_iArgosSpamPunishment = m_iArgosSpamPunishment;
	thePrefs.m_iArgosBadHelloPunishment = m_iArgosBadHelloPunishment;
	thePrefs.m_iArgosBadProtPunishment = m_iArgosBadProtPunishment;

	thePrefs.m_bArgosLeecherModDetection = m_bArgosLeecherModDetection;
	thePrefs.m_uArgosLeecherNickDetection = m_uArgosLeecherNickDetection;
	thePrefs.m_iArgosDetectionLevel = m_iArgosDetectionLevel;
	thePrefs.m_bArgosOpcodeDetection = m_bArgosOpcodeDetection;
	thePrefs.m_bArgosLeecherHashDetection = m_bArgosLeecherHashDetection;
	thePrefs.m_bArgosNickThiefDetection = m_bArgosNickThiefDetection;
	thePrefs.m_bPlainAntiNickThief = m_bPlainAntiNickThief;
	thePrefs.m_bArgosModThiefDetection = m_bArgosModThiefDetection;
	thePrefs.m_bArgosHashThiefDetection = m_bArgosHashThiefDetection;
	thePrefs.m_bArgosCreditHackDetection = m_bArgosCreditHackDetection;
	thePrefs.m_bHashChangeDetection = m_bHashChangeDetection;
	thePrefs.m_bArgosGhostModDetection = m_bArgosGhostModDetection;
	thePrefs.m_uArgosFakeClientDetection = m_uArgosFakeClientDetection;
	thePrefs.m_uAgressionDetection = m_uAgressionDetection;
	thePrefs.m_iAgressionIntervals = m_iAgressionIntervals;
	thePrefs.m_iAgressionThreshold = m_iAgressionThreshold;
	thePrefs.m_bFileScannerDetection = m_bFileScannerDetection;
	thePrefs.m_bFileFakerDetection = m_bFileFakerDetection;
	thePrefs.m_bBadSenderDetection = m_bBadSenderDetection;
	thePrefs.m_bRankFloodDetection = m_bRankFloodDetection;
	thePrefs.m_bFailedDetection = m_bFailedDetection;
	thePrefs.m_iFailedTries = m_iFailedTries;
	thePrefs.m_iFailedThreshold = m_iFailedThreshold;
	thePrefs.m_bXSExploitDetection = m_bXSExploitDetection;
	thePrefs.m_iXSExploitIntervals = m_iXSExploitIntervals;
	thePrefs.m_iXSExploitThreshold = m_iXSExploitThreshold;
	thePrefs.m_bNickChangerDetection = m_bNickChangerDetection;
	thePrefs.m_iNickChangeIntervals = m_iNickChangeIntervals;
	thePrefs.m_iNickChangeThreshold = m_iNickChangeThreshold;
	thePrefs.m_bModChangerDetection = m_bModChangerDetection;
	thePrefs.m_iModChangeIntervals = m_iModChangeIntervals;
	thePrefs.m_iModChangeThreshold = m_iModChangeThreshold;
	thePrefs.m_bNullNickDetection = m_bNullNickDetection;
	thePrefs.m_bSpamDetection = m_bSpamDetection;
	thePrefs.m_bBadHelloDetection = m_bBadHelloDetection;
	thePrefs.m_ueMCryptDetection = m_ueMCryptDetection;
	thePrefs.m_bBadProtDetection = m_bBadProtDetection;
	thePrefs.m_uDLPDetection = m_uDLPDetection;

	thePrefs.m_bArgosLogLeechers = m_bArgosLogLeechers;

	if(bReloadArgos){
		if(bUseArgosEngine && m_uDLPDetection != 2 && m_bUseArgosSystem)
			theApp.argos->LoadFromFile();
		else
			theApp.argos->RemoveAllKnownLeechers();

		if(bUseArgosEngine && m_uDLPDetection && m_bUseArgosSystem)
			theApp.argos->LoadDLPlibrary();
		else
			theApp.argos->UnLoadDLPlibrary();
	}

	thePrefs.CheckSilverPreferences();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

BOOL CPPgArgos::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgArgos::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

LRESULT CPPgArgos::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_PRF_ARGOS_TREECTRL){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			if(m_htiArgosTrustTime && pton->hItem == m_htiArgosTrustTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosTrustTime, TIM_ARGOS_TRUST_TIME_MIN, TIM_ARGOS_TRUST_TIME_DEF, TIM_ARGOS_TRUST_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosProcessTime && pton->hItem == m_htiArgosProcessTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosProcessTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosTrackTime && pton->hItem == m_htiArgosTrackTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosTrackTime, TIM_ARGOS_TRACK_TIME_MIN, TIM_ARGOS_TRACK_TIME_DEF, TIM_ARGOS_TRACK_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosGenericBanTime && pton->hItem == m_htiArgosGenericBanTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosGenericBanTime, TIM_ARGOS_GENERIC_BAN_TIME_MIN, TIM_ARGOS_GENERIC_BAN_TIME_DEF, TIM_ARGOS_GENERIC_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosAgressionBanTime && pton->hItem == m_htiArgosAgressionBanTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosAgressionBanTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiAgressionIntervals && pton->hItem == m_htiAgressionIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAgressionIntervals, TIM_ARGOS_AGRESSION_INTERVALS_MIN, TIM_ARGOS_AGRESSION_INTERVALS_DEF, TIM_ARGOS_AGRESSION_INTERVALS_MAX)) SetModified();
			}
			else if(m_htiAgressionThreshold && pton->hItem == m_htiAgressionThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAgressionThreshold, VAL_ARGOS_AGRESSION_THRESHOLD_MIN, VAL_ARGOS_AGRESSION_THRESHOLD_DEF, VAL_ARGOS_AGRESSION_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiArgosOpCodeTime && pton->hItem == m_htiArgosOpCodeTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosOpCodeTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosHashChangedTime && pton->hItem == m_htiArgosHashChangedTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosHashChangedTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosRankFlooderTime && pton->hItem == m_htiArgosRankFlooderTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosRankFlooderTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosGhostModeTime && pton->hItem == m_htiArgosGhostModeTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosGhostModeTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosCorruptedSenderTime && pton->hItem == m_htiArgosCorruptedSenderTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosCorruptedSenderTime, TIM_ARGOS_BAN_BAD_TIME_MIN, TIM_ARGOS_BAN_TIME_CORRUPT_DEF, TIM_ARGOS_BAN_BAD_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosFileScannerTime && pton->hItem == m_htiArgosFileScannerTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosFileScannerTime, TIM_ARGOS_BAN_BAD_TIME_MIN, TIM_ARGOS_BAN_TIME_SCANNER_DEF, TIM_ARGOS_BAN_BAD_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosFileFakerTime && pton->hItem == m_htiArgosFileFakerTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosFileFakerTime, TIM_ARGOS_BAN_BAD_TIME_MIN, TIM_ARGOS_BAN_TIME_SCANNER_DEF, TIM_ARGOS_BAN_BAD_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosFailedTime && pton->hItem == m_htiArgosFailedTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosFailedTime, TIM_ARGOS_BAN_BAD_TIME_MIN, TIM_ARGOS_BAN_TIME_FAILED_DEF, TIM_ARGOS_BAN_BAD_TIME_MAX)) SetModified();
			}
			else if(m_htiFailedTries && pton->hItem == m_htiFailedTries){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFailedTries, VAL_ARGOS_FAILED_TRIES_MIN, VAL_ARGOS_FAILED_TRIES_DEF, VAL_ARGOS_FAILED_TRIES_MAX)) SetModified();
			}
			else if(m_htiFailedThreshold && pton->hItem == m_htiFailedThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFailedThreshold, VAL_ARGOS_FAILED_THRESHOLD_MIN, VAL_ARGOS_FAILED_THRESHOLD_DEF, VAL_ARGOS_FAILED_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiArgosXSExploitTime && pton->hItem == m_htiArgosXSExploitTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosXSExploitTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiXSExploitIntervals && pton->hItem == m_htiXSExploitIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSExploitIntervals, TIM_ARGOS_XS_EXPLOIT_INTERVALS_MIN, TIM_ARGOS_XS_EXPLOIT_INTERVALS_DEF, TIM_ARGOS_XS_EXPLOIT_INTERVALS_MAX)) SetModified();
			}
			else if(m_htiXSExploitThreshold && pton->hItem == m_htiXSExploitThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSExploitThreshold, VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MIN, VAL_ARGOS_XS_EXPLOIT_THRESHOLD_DEF, VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiArgosNickChangerTime && pton->hItem == m_htiArgosNickChangerTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosNickChangerTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiNickChangeIntervals && pton->hItem == m_htiNickChangeIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNickChangeIntervals, TIM_ARGOS_NICK_CHANGE_INTERVALS_MIN, TIM_ARGOS_NICK_CHANGE_INTERVALS_DEF, TIM_ARGOS_NICK_CHANGE_INTERVALS_MAX)) SetModified();
			}
			else if(m_htiNickChangeThreshold && pton->hItem == m_htiNickChangeThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNickChangeThreshold, VAL_ARGOS_NICK_CHANGE_THRESHOLD_MIN, VAL_ARGOS_NICK_CHANGE_THRESHOLD_DEF, VAL_ARGOS_NICK_CHANGE_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiArgosModChangerTime && pton->hItem == m_htiArgosModChangerTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosModChangerTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiModChangeIntervals && pton->hItem == m_htiModChangeIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiModChangeIntervals, TIM_ARGOS_MOD_CHANGE_INTERVALS_MIN, TIM_ARGOS_MOD_CHANGE_INTERVALS_DEF, TIM_ARGOS_MOD_CHANGE_INTERVALS_MAX)) SetModified();
			}
			else if(m_htiModChangeThreshold && pton->hItem == m_htiModChangeThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiModChangeThreshold, VAL_ARGOS_MOD_CHANGE_THRESHOLD_MIN, VAL_ARGOS_MOD_CHANGE_THRESHOLD_DEF, VAL_ARGOS_MOD_CHANGE_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiArgosNullNickTime && pton->hItem == m_htiArgosNullNickTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosNullNickTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosSpamTime && pton->hItem == m_htiArgosSpamTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosSpamTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosBadHelloTime && pton->hItem == m_htiArgosBadHelloTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosBadHelloTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}
			else if(m_htiArgosBadProtTime && pton->hItem == m_htiArgosBadProtTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiArgosBadProtTime, TIM_ARGOS_BAN_TIME_MIN, TIM_ARGOS_BAN_TIME_DEF, TIM_ARGOS_BAN_TIME_MAX)) SetModified();
			}

		}else{
			if (m_htiUseArgosSystem){
				CheckEnable();
			}
			SetModified();
		}
	}
	return 0;
}

void CPPgArgos::CheckEnable(){
	UINT bCheck1;
	UINT bCheck2;
	UINT bCheck3;
	UINT bCheck4;

	m_ctrlTreeOptions.GetCheckBox(m_htiUseArgosSystem, bCheck1);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosTrustTime, bCheck1);
		m_ctrlTreeOptions.SetItemEnable(m_htiCreditCompensation, bCheck1);
		m_ctrlTreeOptions.SetItemEnable(m_htiDontBanFriends, bCheck1);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosLogLeechers, bCheck1);
	
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosLeecherDetection, bCheck1);
		m_ctrlTreeOptions.GetCheckBox(m_htiArgosLeecherModDetection, bCheck4);
		if(!bCheck4)
			m_ctrlTreeOptions.GetCheckBox(m_htiArgosLeecherNickDetection, bCheck4);
		if(!bCheck4)
			m_ctrlTreeOptions.GetCheckBox(m_htiArgosOpcodeDetection, bCheck4);
		m_ctrlTreeOptions.GetCheckBox(m_htiArgosOpcodeDetection, bCheck3);
			m_ctrlTreeOptions.SetItemEnable(m_htiArgosOpCodeTime, bCheck1 && bCheck3);
		if(!bCheck4)
			m_ctrlTreeOptions.GetCheckBox(m_htiArgosLeecherHashDetection, bCheck4);

		if(bCheck3)
			bCheck4 = TRUE;

		m_ctrlTreeOptions.GetCheckBox(m_htiDLPDetection, bCheck3);
			m_ctrlTreeOptions.SetItemEnable(m_htiDLPDetectionReload, bCheck1 && bCheck3);
		bCheck2 = (bCheck3 || bCheck4);

		m_ctrlTreeOptions.SetItemEnable(m_htiArgosDetectionLevel, bCheck1 && bCheck4);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosDetectionReload, bCheck1 && bCheck4 && bCheck3 != 2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosGPLBreakerPunishment, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosHardLeecherPunishment, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNormalLeecherPunishment, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosSoftLeecherPunishment, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosBadModPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosNickThiefDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosNickThiefDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNickThiefPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosModThiefDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosModThiefDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosModThiefPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosHashThiefDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosHashThiefDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiTrustUnArgosHashThief, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosHashThiefPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosCreditHackDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosCreditHackPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiHashChangeDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosHashChangedTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiTrustUnArgosHashChanged, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosHashChangedPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosGhostModDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosGhostModDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosGhostModeTime, bCheck1 && bCheck2);	
		m_ctrlTreeOptions.SetItemEnable(m_htiTrustUnArgosGhostMode, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosGhostModePunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiArgosFakeClientDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiArgosFakeClientDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFakeClientPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiAgressionDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiAgressionIntervals, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiAgressionThreshold, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosAgressionBanTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiTrustUnArgosAgressiv, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosAgressonPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiFileScannerDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFileScannerTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFileScannerPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiFileFakerDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiFileFakerDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFileFakerTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFileFakerPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiBadSenderDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosCorruptedSenderTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosCorruptedSenderPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiRankFloodDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosRankFlooderTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosRankFlooderPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiFailedDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiFailedDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiFailedTries, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiFailedThreshold, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFailedTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosFailedPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiXSExploitDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiXSExploitDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiXSExploitIntervals, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiXSExploitThreshold, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosXSExploitTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosXSExploitPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiNickChangerDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiNickChangerDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiNickChangeIntervals, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiNickChangeThreshold, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNickChangerTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNickChangerPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiModChangerDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiModChangerDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiModChangeIntervals, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiModChangeThreshold, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosModChangerTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosModChangerPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiNullNickDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNullNickTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosNullNickPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.GetCheckBox(m_htiSpamDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosSpamTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosSpamPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiBadHelloDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiBadHelloDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htieMCryptDetection, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosBadHelloTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosBadHelloPunishment, bCheck1 && bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiBadProtDetection, bCheck1);
	m_ctrlTreeOptions.GetCheckBox(m_htiBadProtDetection, bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosBadProtTime, bCheck1 && bCheck2);
		m_ctrlTreeOptions.SetItemEnable(m_htiArgosBadProtPunishment, bCheck1 && bCheck2);
}

LRESULT CPPgArgos::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_PRF_ARGOS_TREECTRL){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_PRF_ARGOS_TREECTRL_INFO, *sInfo);
	}
	return FALSE;
}